/**********************************************************************
% Copyright (C) 1998 Ullrich Hustadt
%                    Max-Planck-Institut fuer Informatik
%                    Im Stadtwald
%                    66123 Saarbruecken, Germany
% Version 1.2 of ftdriver.pl
%
% ftdriver.pl is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 1, or (at your option)
% any later version.

% ftdriver.pl is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
**********************************************************************/

% ftdriver.pl needs to know in which directory the file alc.pl 
% can be found. Set it according to the variable *gent-pathname* 
% in genalc.lsp.

gent_pathname('/var/tmp/').

% ftdriver.pl needs to know where the binaries of FLOTTER, SPASS, etc.
% can be found. 
%
%% Complete path of form2dfg.

form_binary('/home/ullrich/provers/SPASS-0.55/Source/form2dfg').

%% Complete path of FLOTTER.

flotter_binary('/home/ullrich/provers/SPASS-0.55/Source/FLOTTER').

%% Complete path of SPASS.

spass_binary('/home/ullrich/provers/SPASS-0.55/Source/SPASS').

%% Complete path of prepare-flotter

diamond_binary('/home/ullrich/provers/TA/prepare-flotter').

%% Complete path of prepare-spass

settings_binary('/home/ullrich/provers/TA/prepare-spass').

% The simplification procedure has two options:
% a) If in

option(simplify,yes).

% the second argument of option is set to `yes', then the simplifi-
% cation procedure is applied, otherwise not.
% b) If in

option(ac,yes).

% the second argument of option is set to `yes', then the simplifi-
% cation procedure can make use of the associativity and commutativity
% of `and' and `or' in term comparisons.

/*********************************************************************
 Nothing needs to be changed below this line.
**********************************************************************/

:- use_module(library(system)).
:- compile('ftmodal.pl').
:- compile('simplify.pl').
:- dynamic gensym_symbol/2.
:- dynamic gensym_counter/2.

testSAT(GR) :-
	gent_pathname(Dir),
	generateFilename(Dir,'alc.pl',File),
	testSAT(File,GR).

testSAT(File,_GR) :-
	gent_pathname(Dir),
	form_binary(FORMBIN),
	flotter_binary(FLOTTERBIN),
	settings_binary(SETTINGSBIN),
	spass_binary(SPASSBIN),
	see(File),
	read(Term1),
	seen,
	getRuntime(T0),
	simplify_alc(Term1,Term2),
	getRuntime(T1),
	T is T1 - T0,
	generateFilename(Dir,'fol.in',FOL_File),
	tell(FOL_File),
	print('(not '),
	printTerm(alc2cnfres_fol,[],Term2),
	print(')'),
	told,
	retractall(gensym_symbol(_,_)),
	generateFilename(Dir,'flotter.in',FLOTTER_File),
	generateFilename(Dir,'spass.in',SPASS_Input_File),
	generateFilename(Dir,'spass.out',SPASS_Output_File),
	format("Starting satisfiability check of ~a~n",[File]),
	format("using - (optimized functional) translation of ALC to first-order logic (Version 1.1);~n",[]),
	format("      - FLOTTER to translate the first-order formula to clauses;~n",[]),
	format("      - SPASS  to perform the computation.~n",[]),
	format("SIMPLIFY runtime: ~3d~n",T),
	format("FLOTTER output:~n",[]),
	(Term2 == false ->
	    print_SPASS_log('Proof found')
	;
	    (Term2 == true ->
		print_SPASS_log('Completion found')
	    ;
		ttyflush,
		systemCall(shell(_S1),[FORMBIN,' ',FOL_File,' ',FLOTTER_File]),
		systemCall(shell(_S2),['time ',FLOTTERBIN,' ',FLOTTER_File,' ',SPASS_Input_File]),
		ttyflush,
		systemCall(exec,[SETTINGSBIN,' ',SPASS_Input_File]),
		systemCall(exec,['nice -19 ',SPASSBIN,' ',SPASS_Input_File,' 1> ',SPASS_Output_File,' 2>&1']),
		systemCall(system,['cat ',SPASS_Output_File])
	    )
	),
	ttyflush.

systemCall(CallPredicate,Command) :-
	once(systemCall(Command,[],CallPredicate)),
	!.
systemCall(_,Command) :-
	write('SystemCall of '),
	write(Command),
	write(' failed.'),
	nl,
	!.

systemCall([],CommandString,system) :-
	atom_chars(Command,CommandString),
	system(Command).
systemCall([],CommandString,exec) :-
	atom_chars(Command,CommandString),
	exec(Command,[null,null,null],PID),
	wait(PID,_S).
systemCall([],CommandString,shell) :-
	atom_chars(Command,CommandString),
	shell(Command).
systemCall([],CommandString,shell(Result)) :-
	atom_chars(Command,CommandString),
	shell(Command,Result).
systemCall([A|L],CommandString1,CallPredicate) :-
	(number(A) ->
	    number_chars(A,AC)
	;
	    (atomic(A) ->
		atom_chars(A,AC)
	    ;
		AC = A
	    )
	),
	append(CommandString1,AC,CommandString2),
	systemCall(L,CommandString2,CallPredicate).

print_SPASS_log(String) :-
	format("0.00u 0.00s 0:00.00 89.4%~n~n",[]),
        format("SPASS beiseite: ~a.~n",String),
	format("SPASS derived 0 clauses, backtracked 0 clauses and kept 0 clauses.~n",[]),
	format("SPASS spent     0:00:00.01 on the problem.~n",[]),
	format("SPASS spent     0:00:00.00 for the input.~n",[]).

getRuntime(RT) :-
        statistics(runtime,[RT|_]).

generateFilename(DIR,Name,File) :-
	atom_chars(DIR,S1),
	atom_chars(Name,S2),
	append(S1,S2,S3),
	atom_chars(File,S3).

once(Call) :-
	call(Call),
	!.
